/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.item.ItemBaitBucket;

public class RecipeBaitBucket
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.validInput(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack itemBait;
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemBaitBucket = inv.func_70301_a(slots[0].intValue()).func_77946_l();
        ItemStack itemStack = itemBait = slots[1] != -1 ? inv.func_70301_a(slots[1].intValue()).func_77946_l() : null;
        if (itemBait == null) {
            ItemBaitBucket.removeBait(itemBaitBucket);
        } else {
            int count = slots.length - 1;
            ItemBaitBucket.setBaitId(itemBaitBucket, ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemBait.func_77973_b())).toString());
            ItemBaitBucket.setBaitMetadata(itemBaitBucket, itemBait.func_77960_j());
            ItemBaitBucket.setBaitDisplayName(itemBaitBucket, itemBait.func_82833_r());
            ItemBaitBucket.setBaitCount(itemBaitBucket, ItemBaitBucket.getBaitCount(itemBaitBucket) + count);
        }
        return itemBaitBucket;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        ItemStack itemBait;
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        Integer[] slots = this.validInput(inv);
        if (slots == null) {
            return ret;
        }
        ItemStack itemBaitBucket = inv.func_70301_a(slots[0].intValue()).func_77946_l();
        ItemStack itemStack = itemBait = slots[1] != -1 ? inv.func_70301_a(slots[1].intValue()).func_77946_l() : null;
        if (itemBait != null || Item.func_111206_d((String)ItemBaitBucket.getBaitId(itemBaitBucket)) == null || ItemBaitBucket.getBaitCount(itemBaitBucket) <= 0) {
            return ret;
        }
        ItemStack oldBait = new ItemStack(Item.func_111206_d((String)ItemBaitBucket.getBaitId(itemBaitBucket)), ItemBaitBucket.getBaitCount(itemBaitBucket), ItemBaitBucket.getBaitMetadata(itemBaitBucket));
        ret.set(0, (Object)oldBait);
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    private Integer[] validInput(InventoryCrafting inv) {
        int i;
        int numStacks = 0;
        int bucketSlot = -1;
        ArrayList<Integer> baitSlots = new ArrayList<Integer>();
        ItemStack bait = null;
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inv.func_70302_i_(); ++i2) {
            if (inv.func_70301_a(i2).func_190926_b()) continue;
            ++numStacks;
            occupiedSlots.add(i2);
        }
        if (numStacks <= 0) {
            return null;
        }
        Iterator i2 = occupiedSlots.iterator();
        while (i2.hasNext()) {
            i = (Integer)i2.next();
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_190926_b()) {
                return null;
            }
            if (itemStack.func_77973_b() instanceof ItemBaitBucket && bucketSlot == -1) {
                bucketSlot = i;
                continue;
            }
            if (BetterFishUtil.isValidBait(itemStack) && (bait == null || itemStack.func_77973_b() == bait.func_77973_b())) {
                baitSlots.add(i);
                bait = itemStack;
                continue;
            }
            return null;
        }
        if (bucketSlot == -1) {
            return null;
        }
        if (numStacks > 1 && !ItemBaitBucket.getBaitId(inv.func_70301_a(bucketSlot)).isEmpty()) {
            if (!ItemBaitBucket.getBaitId(inv.func_70301_a(bucketSlot)).equals(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)inv.func_70301_a(((Integer)baitSlots.get(0)).intValue()).func_77973_b())).toString())) {
                return null;
            }
            if (ItemBaitBucket.getBaitMetadata(inv.func_70301_a(bucketSlot)) != inv.func_70301_a(((Integer)baitSlots.get(0)).intValue()).func_77960_j()) {
                return null;
            }
            if (ItemBaitBucket.getBaitCount(inv.func_70301_a(bucketSlot)) + numStacks - 1 > 64) {
                return null;
            }
        } else if (numStacks == 1 && (ItemBaitBucket.getBaitId(inv.func_70301_a(bucketSlot)).isEmpty() || ItemBaitBucket.getBaitCount(inv.func_70301_a(bucketSlot)) <= 0)) {
            return null;
        }
        Integer[] slots = new Integer[Math.max(2, numStacks)];
        slots[0] = bucketSlot;
        slots[1] = -1;
        for (i = 0; i < baitSlots.size(); ++i) {
            slots[i + 1] = (Integer)baitSlots.get(i);
        }
        return slots;
    }
}

